#pragma once
#include "afxwin.h"
#include "afxcmn.h"

// CDriverSettings2 dialog
class CDriverSettings2 : public CPropertyPage
{
	DECLARE_DYNAMIC(CDriverSettings2)

public:
	CDriverSettings2();
	virtual ~CDriverSettings2();
	virtual BOOL OnInitDialog();
	CString DeviceName;

// Dialog Data
	enum { IDD = IDD_DRIVERPAGE2 };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
	afx_msg void OnBnClickedBtnDriverBoxClear() {Driver2Msg.SetWindowText(_T(""));}
	afx_msg void OnBnClickedBtnPrintSettings();
	afx_msg void OnBnClickedBtnHoloKote();
	afx_msg void OnBnClickedBtnHolopatch();
	afx_msg void OnBnClickedBtnCardSettings();
	afx_msg void OnBnClickedGetActionRadio();
	afx_msg void OnBnClickedSetActionRadio();
	afx_msg void OnCbnSelchangeCardSettings();
	afx_msg void OnCbnSelchangeHoloKote();
	afx_msg void OnBnClickedBtnColourAdjust();
	afx_msg void OnBnClickedBtnColourArea();
	afx_msg void OnEnChangeColourAreaNo();
	afx_msg void OnCbnSelchangeColourArea();
	afx_msg void OnBnClickedBtnResinOptions();
	afx_msg void OnBnClickedBtnHoloKotePreview();

private:
	CMainSheet *Parent;
	CEdit Driver2Msg;

	int    _iPaperCount;
	WORD  *_pPapers;
	TCHAR *_pPaperNames;

	BOOL Initialised;
	CButton Action;
	int DvrAction;
	CComboBox Duplex;
	CComboBox CardSize;
	CEdit CopyCount;
	CSpinButtonCtrl CopyCount_Spin;
	CComboBox CardSettings_Side;
	CComboBox ColourFormat;
	CComboBox Orientation;
	CButton Overcoat;
	CButton Rotate;
	CComboBox HoloKote_Side;
	CEdit HoloKoteImage;
	CSpinButtonCtrl HoloKoteImage_Spin;
	CEdit HoloKoteMap;
	CComboBox HoloKoteRotate;
	CButton HoloKote_UseLam;
	CButton HoloKote_DisableCK;
	CEdit HoloPatchPosn;
	CSpinButtonCtrl HoloPatchPosn_Spin;
	CButton ColourHole;
	void EnableGetSetControls(BOOL bControl);

	CEdit ColourArea_No;
	CComboBox ColourArea_Side;
	CComboBox ColourArea_Correction;
	CEdit ColourArea_Left;
	CEdit ColourArea_Width;
	CEdit ColourArea_Bottom;
	CEdit ColourArea_Height;
	CSpinButtonCtrl ColourArea_Left_Spin;
	CSpinButtonCtrl ColourArea_Width_Spin;
	CSpinButtonCtrl ColourArea_Bottom_Spin;
	CSpinButtonCtrl ColourArea_Height_Spin;
	CSpinButtonCtrl ColourArea_No_Spin;
	CEdit ColAdj_Contrast;
	CEdit ColAdj_Brightness;
	CEdit ColAdj_Colour;
	CEdit ColAdj_Tint;
	CEdit ColAdj_Red;
	CEdit ColAdj_Green;
	CEdit ColAdj_Blue;
	CButton ColAdj_DarkPic;
	CButton ColAdj_Negative;
	CComboBox ColAdj_Illuminant;
	CEdit ColAdj_BlackRef;
	CEdit ColAdj_WhiteRef;
	CSpinButtonCtrl ColAdj_Contrast_Spin;
	CSpinButtonCtrl ColAdj_Brightness_Spin;
	CSpinButtonCtrl ColAdj_Colour_Spin;
	CSpinButtonCtrl ColAdj_Tint_Spin;
	CSpinButtonCtrl ColAdj_Red_Spin;
	CSpinButtonCtrl ColAdj_Green_Spin;
	CSpinButtonCtrl ColAdj_Blue_Spin;
	CSpinButtonCtrl ColAdj_BlackRef_Spin;
	CSpinButtonCtrl ColAdj_WhiteRef_Spin;
	CButton bBlack_YMC;
	CButton bPics_UseYMC;
	CButton bText_Kresin;
	CButton bBitmaps_KResin;
	CButton bPolygons_KResin;
	CComboBox ResinOptions_Side;
	CButton HoloKotePreviewBtn;

	BOOL ActionIsGet() {UpdateData(); return (DvrAction == 0);}
	void AddDriverMessage(CString pMessage) {Parent->AddString(&Driver2Msg, pMessage);}

	CString CardSizeString(int CardSize);
	CString IlluminantString(int Illuminant);

	void PrintSettingsToMsgBox(PPRINTSET pPrintSettings, ID_READWRITE Action);
	void SetPrintSettings(PPRINTSET pPrintSettings);
	ID_RETURN GetPrintSettings(PPRINTSET pPrintSettings);

	void CardSettingsToMsgBox(ID_SIDE Side, PCARDSET pCardSettings, ID_READWRITE Action);
	void SetCardSettings(PCARDSET pCardSettings);
	ID_RETURN GetCardSettings(ID_SIDE Side, PCARDSET pCardSettings);

	void HoloKoteToMsgBox(ID_SIDE Side,	PHOLOKOTE pHoloKote, ID_READWRITE Action);
	void SetHoloKote(PHOLOKOTE pHoloKote);
	ID_RETURN GetHoloKote(ID_SIDE Side, PHOLOKOTE pHoloKote);

	void HoloPatchToMsgBox(PHOLOPATCH pHoloPatch, ID_READWRITE Action);
	void SetHoloPatch(PHOLOPATCH pHoloPatch);
	ID_RETURN GetHoloPatch(PHOLOPATCH pHoloPatch);

	void ColourAdjToMsgBox(PCOLORADJUSTMENT pca, ID_READWRITE Action);
	void SetColourAdjust(PCOLORADJUSTMENT pca);
	ID_RETURN GetColourAdjust(PCOLORADJUSTMENT pca);

    void SetColourArea(PAREA pArea, COLCORRECT Correction);
    ID_RETURN GetColourArea(ID_SIDE Side, int AreaNo, PAREA pArea, PCOLCORRECT pCorrection);
	void ColourAreaToMsgBox(ID_SIDE Side, int AreaNo, PAREA pArea, ID_READWRITE Action, COLCORRECT Correction);

	void ResinOptionsToMsgBox(ID_SIDE Side, ID_READWRITE Action, K_OPTIONS KOptions);
	void SetResinOptions(K_OPTIONS KOptions);
	ID_RETURN GetResinOptions(ID_SIDE side, PK_OPTIONS pKOptions);
};
